--[[
--Rugby Lua v1.2 by Darren Watts (W'rkncacnter)
--]]

Triggers = {}
red_base_poly = nil
blue_base_poly = nil

regen_timer = 0
BALL_RESET_AMT = 20 * 30
last_touched_ball = BALL_RESET_AMT * 2
ball_created = false
ball_x = 0
ball_y = 0
ball_z = 0
ball_poly = nil
last_player_with_ball = nil
killed_infidels = false
ball_object = nil
num_red_points = 0
num_blue_points = 0

rugby_err = "This is not a valid Rugby map."

function Triggers.init()
	set_base_polys()
	assign_teams()

	for p in Players() do
		p._points = 0
	end
end

function set_base_polys()
	for p in Polygons() do
		if p.type == "base" and p.permutation == 1 then
			red_base_poly = p
		elseif p.type == "base" and p.permutation == 6 then
			blue_base_poly = p
		end
	end
end

function assign_teams()
	for p in Players() do
		if p.team == "red" then
			p.color = "red"
		elseif p.team == "blue" then
			p.color = "blue"
		else
			p.team = "blue"
			p.color = "blue"
			p._infidel = true
		end
	end
end

function Triggers.idle()
	if (red_base_poly == nil or blue_base_poly == nil) then
		Players.print(rugby_err)
		for i = 0, 5, 1 do Players.print(" ") end
	else
		do_rugby()
	end
end

function do_rugby()
	reset_ball()
	rugby_compass()
	lua_hud()
	kill_infidels()
end

function reset_ball()
	if last_player_with_ball and last_player_with_ball.items["ball"] > 0 then last_touched_ball = BALL_RESET_AMT end
	
	if(last_touched_ball <= 0) then
		ball_object:position(ball_x, ball_y, ball_z, ball_poly)
		last_touched_ball = BALL_RESET_AMT
		Players.print("Ball reset!")
		for p in Players() do
			p:play_sound("siren", 1)
		end
	else
		last_touched_ball = last_touched_ball - 1
	end
end

function rugby_compass()
	for p in Players() do
		if p.local_ then
			p.compass.lua = true
			p.compass.beacon = true
			if(p.items["ball"] > 0 and p.team == "red") then
				p.compass.x = blue_base_poly.x
				p.compass.y = blue_base_poly.y
			elseif(p.items["ball"] > 0 and p.team == "blue") then
				p.compass.x = red_base_poly.x
				p.compass.y = red_base_poly.y
			elseif(p.items["ball"] == 0) then
				p.compass.beacon = true
				x, y = get_ball_coords()
				if x == -1 and y == -1 then
					p.compass:all_off()
				else
					p.compass.x = x
					p.compass.y = y
				end
			end
		end
	end
end

function lua_hud()
	for p in Players() do
		p.overlays[0].color = "red"
		p.overlays[0]:fill_icon("red")
		p.overlays[0].text = num_red_points

		p.overlays[1].color = "blue"
		p.overlays[1]:fill_icon("blue")
		p.overlays[1].text = num_blue_points

		color, description = get_ball_description()
		p.overlays[2]:fill_icon(color)
		p.overlays[2].text = description
	end
end

function get_ball_description()
	if Game.ticks < 15 * 30 then
		if Game.ticks == (15 * 30) - 1 then
			for p in Players() do
				p:play_sound("got ball", 1)
			end
		end
		return "white", "Game begins in ".. 15 - math.floor(Game.ticks/30) .." seconds"
	end

	local ball_carrier = nil
	if last_player_with_ball and last_player_with_ball.items["ball"] > 0 then ball_carrier = last_player_with_ball end
	if ball_carrier then
		if ball_carrier.team == "red" then
			return "red", "Red team has ball"
		else
			return "blue", "Blue team has ball"
		end
	else
		return "white", "Ball dropped."
	end
end

function get_ball_coords()
	local plr = last_player_with_ball
	if plr and plr.items["ball"] > 0 then
		return plr.x, plr.y
	elseif ball_object then
		return ball_object.x, ball_object.y
	else
		return -1, -1
	end
end

function kill_infidels()
	if not killed_infidels then
		for p in Players() do
			if p._infidel then
				p:damage(p.life+1) -- Kill players that were neither on red or blue team.  This way they will respawn in the right base
				p.deaths = p.deaths - 1
				p._infidel = false
				p:print("Your team color was neither red nor blue.")
				p:print("The script changed your team color and killed you.")
				p:print("Revive and you should be set.")
			end
		end
	end
	if done then killed_infidels = true end
end

function Triggers.item_created(item)
	if(item.type == "ball" and ball_created == false) then 
		ball_x = item.x
		ball_y = item.y
		ball_z = item.z
		ball_poly = item.polygon
		ball_created = true
		ball_object = item
	elseif(item.type == "ball") then

		-- Mark the ball to be reset immediately if falls on item impassable polygon
		if item.polygon.type == "item impassable" then last_touched_ball = 0 end
		ball_object = item
		if(item.x == ball_x and item.y == ball_y and item.z == ball_z and item.polygon == ball_poly) then
			score_increased = false
			for p in Players() do
				if p._points ~= p.points then
					p._points = p.points
					score_increased = true
					if p.team == "red" then
						Players.print("Red team scored a point!")
						num_red_points = num_red_points + 1
					else
						Players.print("Blue team scored a point!")
						num_blue_points = num_blue_points + 1
					end
					Players.print("Ball reset!")
					for p in Players() do
						p:play_sound("alarm", 1)
					end
				end
			end

			-- Award a point to the opposing team if you bring the ball to your own goal.
			if not score_increased and last_touched_ball > (BALL_RESET_AMT - 30) and not last_player_with_ball.dead then 
				if last_player_with_ball.team == "red" then
					Players.print("Blue team scored a point!  Red team took the ball into their own goal!")
					for p in Players() do
						if p.team == "blue" then
							p.points = p.points + 1
							p._points = p._points + 1
							break
						end
					end
					num_blue_points = num_blue_points + 1
				else
					Players.print("Red team scored a point!  Blue team took the ball into their own goal!")
					for p in Players() do
						if p.team == "red" then
							p.points = p.points + 1
							p._points = p._points + 1
							break
						end
					end
					num_red_points = num_red_points + 1
				end
				Players.print("Ball reset!")
				for p in Players() do
					p:play_sound("alarm", 1)
				end
			end
		end

		-- If the ball lands on a goal, reset it
		if item.polygon.type == "base" then
			last_touched_ball = 0
		end
	end
end

function Triggers.got_item(type, player)
	if type == "ball" then
		last_player_with_ball = player
		ball_object = nil
	end
end
